/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import lotr.common.LOTRReflection;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatCrafting;
import net.minecraft.stats.StatList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.RegistryNamespaced;
import net.minecraft.util.RegistrySimple;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class LOTRBlockReplacement {
    private static boolean initForgeHooks = false;

    public static void replaceVanillaBlock(Block oldBlock, Block newBlock, Class<? extends ItemBlock> itemClass) {
        try {
            Item oldItem = Item.func_150898_a((Block)oldBlock);
            int id = Block.field_149771_c.func_148757_b((Object)oldBlock);
            String blockName = Reflect.getBlockName(oldBlock);
            String registryName = Block.field_149771_c.func_148750_c((Object)oldBlock);
            String itemblockName = blockName;
            if (oldItem != null) {
                itemblockName = Reflect.getItemName(oldItem);
            }
            newBlock.func_149663_c(blockName);
            Reflect.overwriteBlockList(oldBlock, newBlock);
            Reflect.getUnderlyingIntMap(Block.field_149771_c).func_148746_a((Object)newBlock, id);
            Reflect.getUnderlyingObjMap(Block.field_149771_c).put(registryName, newBlock);
            if (!initForgeHooks) {
                ForgeHooks.isToolEffective((ItemStack)new ItemStack(Items.field_151037_a), (Block)Blocks.field_150346_d, (int)0);
                initForgeHooks = true;
            }
            for (int meta = 0; meta <= 15; ++meta) {
                newBlock.setHarvestLevel(oldBlock.getHarvestTool(meta), oldBlock.getHarvestLevel(meta), meta);
            }
            if (itemClass != null) {
                Constructor<?> itemCtor = null;
                for (Constructor<?> ct : itemClass.getConstructors()) {
                    Class<?>[] params = ct.getParameterTypes();
                    if (params.length != 1 || !Block.class.isAssignableFrom(params[0])) continue;
                    itemCtor = ct;
                    break;
                }
                ItemBlock itemblock = ((ItemBlock)itemCtor.newInstance(newBlock)).func_77655_b(itemblockName);
                Reflect.getUnderlyingIntMap(Item.field_150901_e).func_148746_a((Object)itemblock, id);
                Reflect.getUnderlyingObjMap(Item.field_150901_e).put(registryName, itemblock);
                LOTRBlockReplacement.replaceBlockStats(id, newBlock, itemblock);
                LOTRBlockReplacement.replaceRecipesEtc((Item)itemblock);
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Failed to replace vanilla block %s", (Object[])new Object[]{oldBlock.func_149739_a()});
            throw new RuntimeException(e);
        }
    }

    private static void replaceBlockStats(int id, Block newBlock, ItemBlock itemblock) {
        LOTRBlockReplacement.replaceStat(id, StatList.field_75934_C, (StatBase)new StatCrafting("stat.mineBlock." + id, (IChatComponent)new ChatComponentTranslation("stat.mineBlock", new Object[]{new ItemStack(newBlock).func_151000_E()}), (Item)itemblock));
        LOTRBlockReplacement.replaceStat(id, StatList.field_75929_E, (StatBase)new StatCrafting("stat.useItem." + id, (IChatComponent)new ChatComponentTranslation("stat.useItem", new Object[]{new ItemStack((Item)itemblock).func_151000_E()}), (Item)itemblock));
        LOTRBlockReplacement.replaceStat(id, StatList.field_75928_D, (StatBase)new StatCrafting("stat.craftItem." + id, (IChatComponent)new ChatComponentTranslation("stat.craftItem", new Object[]{new ItemStack((Item)itemblock).func_151000_E()}), (Item)itemblock));
    }

    public static void replaceVanillaItem(Item oldItem, Item newItem) {
        try {
            int id = Item.field_150901_e.func_148757_b((Object)oldItem);
            String itemName = Reflect.getItemName(oldItem);
            String registryName = Item.field_150901_e.func_148750_c((Object)oldItem);
            newItem.func_77655_b(itemName);
            Reflect.overwriteItemList(oldItem, newItem);
            Reflect.getUnderlyingIntMap(Item.field_150901_e).func_148746_a((Object)newItem, id);
            Reflect.getUnderlyingObjMap(Item.field_150901_e).put(registryName, newItem);
            LOTRBlockReplacement.replaceItemStats(id, newItem);
            LOTRBlockReplacement.replaceRecipesEtc(newItem);
        }
        catch (Exception e) {
            FMLLog.severe((String)"Failed to replace vanilla item %s", (Object[])new Object[]{oldItem.func_77658_a()});
            throw new RuntimeException(e);
        }
    }

    private static void replaceItemStats(int id, Item newItem) {
        LOTRBlockReplacement.replaceStat(id, StatList.field_75929_E, (StatBase)new StatCrafting("stat.useItem." + id, (IChatComponent)new ChatComponentTranslation("stat.useItem", new Object[]{new ItemStack(newItem).func_151000_E()}), newItem));
        LOTRBlockReplacement.replaceStat(id, StatList.field_75928_D, (StatBase)new StatCrafting("stat.craftItem." + id, (IChatComponent)new ChatComponentTranslation("stat.craftItem", new Object[]{new ItemStack(newItem).func_151000_E()}), newItem));
        if (newItem.func_77645_m()) {
            LOTRBlockReplacement.replaceStat(id, StatList.field_75930_F, (StatBase)new StatCrafting("stat.breakItem." + id, (IChatComponent)new ChatComponentTranslation("stat.breakItem", new Object[]{new ItemStack(newItem).func_151000_E()}), newItem));
        }
    }

    private static void replaceStat(int id, StatBase[] stats, StatBase newStat) {
        StatBase oldStat = stats[id];
        if (oldStat != null && oldStat.field_75975_e.equals(newStat.field_75975_e)) {
            for (int i = 0; i < stats.length; ++i) {
                StatBase otherOldStat = stats[i];
                if (otherOldStat == null || !otherOldStat.field_75975_e.equals(oldStat.field_75975_e)) continue;
                StatList.field_75940_b.remove(otherOldStat);
                StatList.field_75939_e.remove(otherOldStat);
                StatList.field_75938_d.remove(otherOldStat);
                StatList.field_75941_c.remove(otherOldStat);
                Reflect.getOneShotStats().remove(otherOldStat.field_75975_e);
                stats[i] = newStat;
            }
            newStat.func_75971_g();
        }
    }

    private static void replaceRecipesEtc(Item newItem) {
        String newItemName = newItem.func_77658_a();
        List craftingRecipes = CraftingManager.func_77594_a().func_77592_b();
        for (Object obj : craftingRecipes) {
            ItemStack output;
            if (obj instanceof ShapedRecipes && (output = ((ShapedRecipes)obj).func_77571_b()) != null && output.func_77973_b() != null && output.func_77973_b().func_77658_a().equals(newItemName)) {
                LOTRBlockReplacement.injectReplacementItem(output, newItem);
            }
            if (obj instanceof ShapelessRecipes && (output = ((ShapelessRecipes)obj).func_77571_b()) != null && output.func_77973_b() != null && output.func_77973_b().func_77658_a().equals(newItemName)) {
                LOTRBlockReplacement.injectReplacementItem(output, newItem);
            }
            if (obj instanceof ShapedOreRecipe && (output = ((ShapedOreRecipe)obj).func_77571_b()) != null && output.func_77973_b() != null && output.func_77973_b().func_77658_a().equals(newItemName)) {
                LOTRBlockReplacement.injectReplacementItem(output, newItem);
            }
            if (!(obj instanceof ShapelessOreRecipe) || (output = ((ShapelessOreRecipe)obj).func_77571_b()) == null || output.func_77973_b() == null || !output.func_77973_b().func_77658_a().equals(newItemName)) continue;
            LOTRBlockReplacement.injectReplacementItem(output, newItem);
        }
        for (Object obj : AchievementList.field_76007_e) {
            Achievement a = (Achievement)obj;
            ItemStack icon = a.field_75990_d;
            if (!icon.func_77973_b().func_77658_a().equals(newItem.func_77658_a())) continue;
            LOTRBlockReplacement.injectReplacementItem(icon, newItem);
        }
    }

    private static void injectReplacementItem(ItemStack itemstack, Item newItem) {
        NBTTagCompound nbt = new NBTTagCompound();
        itemstack.func_77955_b(nbt);
        itemstack.func_77963_c(nbt);
    }

    private static class Reflect {
        private Reflect() {
        }

        private static void overwriteBlockList(Block oldBlock, Block newBlock) {
            try {
                Field field = null;
                for (Field f : Blocks.class.getDeclaredFields()) {
                    LOTRReflection.unlockFinalField(f);
                    if (f.get(null) != oldBlock) continue;
                    field = f;
                    break;
                }
                LOTRReflection.setFinalField(Blocks.class, null, newBlock, field);
            }
            catch (Exception e) {
                LOTRReflection.logFailure(e);
            }
        }

        private static void overwriteItemList(Item oldItem, Item newItem) {
            try {
                Field field = null;
                for (Field f : Items.class.getDeclaredFields()) {
                    LOTRReflection.unlockFinalField(f);
                    if (f.get(null) != oldItem) continue;
                    field = f;
                    break;
                }
                LOTRReflection.setFinalField(Items.class, null, newItem, field);
            }
            catch (Exception e) {
                LOTRReflection.logFailure(e);
            }
        }

        private static String getBlockName(Block block) {
            try {
                return (String)ObfuscationReflectionHelper.getPrivateValue(Block.class, (Object)block, (String[])new String[]{"unlocalizedName", "field_149770_b"});
            }
            catch (Exception e) {
                LOTRReflection.logFailure(e);
                return null;
            }
        }

        private static String getItemName(Item item) {
            try {
                return (String)ObfuscationReflectionHelper.getPrivateValue(Item.class, (Object)item, (String[])new String[]{"unlocalizedName", "field_77774_bZ"});
            }
            catch (Exception e) {
                LOTRReflection.logFailure(e);
                return null;
            }
        }

        private static ObjectIntIdentityMap getUnderlyingIntMap(RegistryNamespaced registry) {
            try {
                return (ObjectIntIdentityMap)ObfuscationReflectionHelper.getPrivateValue(RegistryNamespaced.class, (Object)registry, (String[])new String[]{"underlyingIntegerMap", "field_148759_a"});
            }
            catch (Exception e) {
                LOTRReflection.logFailure(e);
                return null;
            }
        }

        private static Map getUnderlyingObjMap(RegistryNamespaced registry) {
            try {
                return (Map)ObfuscationReflectionHelper.getPrivateValue(RegistrySimple.class, (Object)registry, (String[])new String[]{"registryObjects", "field_82596_a"});
            }
            catch (Exception e) {
                LOTRReflection.logFailure(e);
                return null;
            }
        }

        private static Map getOneShotStats() {
            try {
                return (Map)ObfuscationReflectionHelper.getPrivateValue(StatList.class, null, (String[])new String[]{"oneShotStats", "field_75942_a"});
            }
            catch (Exception e) {
                LOTRReflection.logFailure(e);
                return null;
            }
        }
    }
}

